<?php

declare(strict_types=1);

use Makro\Event\EventDispatcher;
use Makro\Event\ListenerProvider;
use Makro\Event\StoppableEvent;

it('stops propagation for stoppable events', function () {
    $provider = new ListenerProvider();
    $hits = 0;

    class StopMe extends StoppableEvent {}

    $provider->listen(StopMe::class, function (StopMe $e) use (&$hits) {
        $hits++; $e->stopPropagation();
    }, 10);

    $provider->listen(StopMe::class, function (StopMe $e) use (&$hits) {
        $hits++;
    }, 0);

    (new EventDispatcher($provider))->dispatch(new StopMe());

    expect($hits)->toBe(1);
});
