<?php

declare(strict_types=1);

use Makro\Event\NullEventDispatcher;
use Makro\Event\StoppableEvent;
use Psr\EventDispatcher\EventDispatcherInterface;

it('is a PSR-14 no-op dispatcher and returns the same event instance', function () {
    $dispatcher = new NullEventDispatcher();

    // implements PSR-14
    expect($dispatcher)->toBeInstanceOf(EventDispatcherInterface::class);

    $event = new stdClass();
    $out   = $dispatcher->dispatch($event);

    // exakt dasselbe Objekt zurück
    expect($out)->toBe($event);
});

it('does not affect stoppable events or their state', function () {
    $dispatcher = new NullEventDispatcher();

    $e1 = new class extends StoppableEvent{};
    $out1 = $dispatcher->dispatch($e1);

    expect($out1)->toBe($e1)            // identisch
    ->and($e1->isPropagationStopped())->toBeFalse(); // Zustand unverändert

    // bereits gestopptes Event bleibt gestoppt
    $e1->stopPropagation();
    $out2 = $dispatcher->dispatch($e1);

    expect($out2)->toBe($e1)
        ->and($e1->isPropagationStopped())->toBeTrue();
});
