<?php

declare(strict_types=1);

use Makro\Event\EventDispatcher;
use Makro\Event\ListenerProvider;

it('matches parent classes and interfaces', function () {
    $provider = new ListenerProvider();
    $called = [];

    interface DomainEvent {}
    class BaseEvent implements DomainEvent {}
    class ChildEvent extends BaseEvent {}

    $called = new ArrayObject();
    $provider->listen(BaseEvent::class, fn(BaseEvent $e) => $called->append('base'));
    $provider->listen(DomainEvent::class, fn(DomainEvent $e) => $called->append('iface'));

    (new EventDispatcher($provider))->dispatch(new ChildEvent());

    expect((array)$called)->toEqual(['base','iface']);
});
