<?php

declare(strict_types=1);

use Makro\Event\EventDispatcher;
use Makro\Event\ListenerProvider;

it('dispatches in priority order', function () {
    $provider = new ListenerProvider();

    class E1 {}

    $log = new ArrayObject();
    $provider->listen(E1::class, fn(E1 $e) => $log->append('p10'), 10);
    $provider->listen(E1::class, fn(E1 $e) => $log->append('p50'), 50);
    $provider->listen(E1::class, fn(E1 $e) => $log->append('p0'), 0);

    (new EventDispatcher($provider))->dispatch(new E1());

    expect((array)$log)->toEqual(['p50','p10','p0']);
});
