<?php

declare(strict_types=1);

namespace Makro\Event;

use Psr\EventDispatcher\ListenerProviderInterface;

final class ListenerProvider implements ListenerProviderInterface
{
    /** @var array<string, list<array{priority:int, listener:callable}>> */
    private array $map = [];

    public function listen(string $eventClass, callable $listener, int $priority = 0): void
    {
        $this->map[$eventClass][] = ['priority' => $priority, 'listener' => $listener];
        usort($this->map[$eventClass], fn ($a, $b) => $b['priority'] <=> $a['priority']);
    }

    public function getListenersForEvent(object $event): iterable
    {
        $class = $event::class;

        foreach ($this->map[$class] ?? [] as $e) {
            yield $e['listener'];
        }

        foreach ($this->map as $eventClass => $listeners) {
            if ($eventClass !== $class && is_a($event, $eventClass)) {
                foreach ($listeners as $e) {
                    yield $e['listener'];
                }
            }
        }
    }
}
