<?php
declare(strict_types=1);

namespace Tests\Core\Result;

use Makro\Command\Result\CommandHandlerResult;

it('creates success result with data and optional message', function () {
    $r = CommandHandlerResult::success(['id' => 1], 'ok');
    expect($r->success)->toBeTrue()
        ->and($r->message)->toBe('ok')
        ->and($r->data)->toMatchArray(['id' => 1]);
});

it('creates failure result with message and optional data', function () {
    $r = CommandHandlerResult::failure('boom', ['err' => 123]);
    expect($r->success)->toBeFalse()
        ->and($r->message)->toBe('boom')
        ->and($r->data['err'])->toBe(123);
});

it('constructs directly (ctor path)', function () {
    $r = new CommandHandlerResult(false, null, []);
    expect($r->success)->toBeFalse()
        ->and($r->message)->toBeNull()
        ->and($r->data)->toBeArray();
});
