<?php

declare(strict_types=1);

namespace Tests\Core\Guard;

use Makro\Command\CommandHandler\AbstractCommandHandler;
use Makro\Command\Result\CommandHandlerResult;
use Makro\Command\Contract\CommandInterface;

// Namespace/Name so wählen, dass KEINE passenden Guards existieren:
namespace Tests\Fixtures\NoGuards\Command;
use Makro\Command\Contract\CommandInterface;
final class NoGuardsCommand implements CommandInterface {}

namespace Tests\Fixtures\NoGuards\CommandHandler;
use Makro\Command\CommandHandler\AbstractCommandHandler;
use Makro\Command\Result\CommandHandlerResult;
use Makro\Command\Contract\CommandInterface;
use Tests\Fixtures\NoGuards\Command\NoGuardsCommand;

/** @extends AbstractCommandHandler<NoGuardsCommand> */
final class NoGuardsCommandHandler extends AbstractCommandHandler {
    /** @param NoGuardsCommand $command */
    protected function doHandle(CommandInterface $command): CommandHandlerResult {
        return CommandHandlerResult::success(['ok' => true]);
    }
}

// ==== Test ====
namespace Tests\Core;

use Tests\Fixtures\NoGuards\CommandHandler\NoGuardsCommandHandler;
use Tests\Fixtures\NoGuards\Command\NoGuardsCommand;

it('falls back to NullCommand[Handler]Guard when no guards exist', function () {
    $h = new NoGuardsCommandHandler();
    $r = $h->handle(new NoGuardsCommand());
    expect($r->success)->toBeTrue()->and($r->data['ok'])->toBeTrue();
    // Dabei wurden implizit beide Null-Guards aufgerufen:
    // - HandlerGuard im Konstruktor (assert)
    // - CommandGuard in handle() (assert)
});
