<?php

declare(strict_types=1);

/**
 * Test: Injizierte Guards überschreiben Defaults.
 * Konventions-Namespace + -Namen werden eingehalten.
 */

namespace Tests\Core\CommandHandler;

use Makro\Command\Result\CommandHandlerResult;
use Makro\Command\Contract\CommandInterface;

/* ===================== Fixtures ===================== */
namespace Tests\Fixtures\Injected\Command;

use Makro\Command\Contract\CommandInterface as CI;
final class InjectedCommand implements CI {}

namespace Tests\Fixtures\Injected\CommandHandler;

use Makro\Command\CommandHandler\AbstractCommandHandler;
use Makro\Command\Result\CommandHandlerResult;
use Makro\Command\Contract\CommandInterface;
use Tests\Fixtures\Injected\Command\InjectedCommand;

/** @extends AbstractCommandHandler<InjectedCommand> */
final class InjectedCommandHandler extends AbstractCommandHandler
{
    /** @param InjectedCommand $command */
    protected function doHandle(CommandInterface $command): CommandHandlerResult
    {
        return CommandHandlerResult::success(['ok' => true]);
    }
}

namespace Tests\Fixtures\Injected\Spy;

use Makro\Command\Contract\CommandInterface;
use Makro\Command\Contract\CommandGuardInterface;
use Makro\Command\Contract\CommandHandlerGuardInterface;
use Makro\Command\Contract\CommandHandlerInterface;

final class SpyCommandGuard implements CommandGuardInterface {
    public static int $calls = 0;
    public function assert(CommandInterface $command): void { self::$calls++; }
}
final class SpyHandlerGuard implements CommandHandlerGuardInterface {
    public static int $calls = 0;
    public function assert(CommandHandlerInterface $handler): void { self::$calls++; }
}

/* ======================= Test ======================= */
namespace Tests\Core\CommandHandler;

use Tests\Fixtures\Injected\Command\InjectedCommand;
use Tests\Fixtures\Injected\CommandHandler\InjectedCommandHandler;
use Tests\Fixtures\Injected\Spy\SpyCommandGuard;
use Tests\Fixtures\Injected\Spy\SpyHandlerGuard;

it('uses injected guards instead of defaults', function () {
    SpyCommandGuard::$calls = 0;
    SpyHandlerGuard::$calls = 0;

    $h = new InjectedCommandHandler(new SpyHandlerGuard(), new SpyCommandGuard());
    $r = $h->handle(new InjectedCommand());

    expect($r->success)->toBeTrue()
        ->and($r->data['ok'])->toBeTrue()
        ->and(SpyHandlerGuard::$calls)->toBe(1) // ctor-assert
        ->and(SpyCommandGuard::$calls)->toBe(1); // handle-assert
});
