<?php

declare(strict_types=1);

/* ==== Fixture: normaler Demo-Command & Handler ==== */
namespace Tests\Fixtures\BatchEdge\Command;

use Makro\Command\Contract\CommandInterface;
final class EdgeCmdCommand implements CommandInterface
{
    public function __construct(public bool $crash = false) {}
}

namespace Tests\Fixtures\BatchEdge\CommandHandler;

use Makro\Command\CommandHandler\AbstractCommandHandler;
use Makro\Command\Contract\CommandInterface;
use Makro\Command\Result\CommandHandlerResult;
use Tests\Fixtures\BatchEdge\Command\EdgeCmdCommand;

/** @extends AbstractCommandHandler<EdgeCmdCommand> */
final class EdgeCmdCommandHandler extends AbstractCommandHandler
{
    /** @param EdgeCmdCommand $command */
    protected function doHandle(CommandInterface $command): CommandHandlerResult
    {
        /** @var EdgeCmdCommand $command */
        if ($command->crash) {
            throw new \RuntimeException('crash');
        }
        return CommandHandlerResult::success();
    }
}

/* ==== Fixtures: schlechte Inner-Handler für inferExpectedFromInner() ==== */
// 1) Kein \CommandHandler\ im FQCN
namespace Tests\Fixtures\BadInner\NoMarker;

use Makro\Command\CommandHandler\AbstractCommandHandler;
use Makro\Command\Contract\CommandInterface;
use Makro\Command\Result\CommandHandlerResult;

final class BadInnerHandler extends AbstractCommandHandler
{
    protected function doHandle(CommandInterface $command): CommandHandlerResult
    { return CommandHandlerResult::success(); }
}

// 2) \CommandHandler\ da, aber passende *Command-Klasse* existiert nicht
namespace Tests\Fixtures\BadInner\CommandHandler;

use Makro\Command\CommandHandler\AbstractCommandHandler;
use Makro\Command\Contract\CommandInterface;
use Makro\Command\Result\CommandHandlerResult;

final class MissingCommandHandler extends AbstractCommandHandler
{
    protected function doHandle(CommandInterface $command): CommandHandlerResult
    { return CommandHandlerResult::success(); }
}

/* ==== Tests ==== */
namespace Tests\Core\Batch;

use Tests\Fixtures\BatchEdge\Command\EdgeCmdCommand;
use Tests\Fixtures\BatchEdge\CommandHandler\EdgeCmdCommandHandler;
use Makro\Command\Command\BatchCommand;
use Makro\Command\CommandHandler\BatchCommandHandler;

it('stops on first exception when stopOnFirstError=true', function () {
    $items = [ new EdgeCmdCommand(), new EdgeCmdCommand(crash: true), new EdgeCmdCommand() ];
    $batch = new BatchCommand($items, stopOnFirstError: true);

    $handler = new BatchCommandHandler(new EdgeCmdCommandHandler());
    $res = $handler->handle($batch);

    expect($res->success)->toBeFalse()
        ->and($res->data['total'])->toBe(2)          // drittes Item nicht verarbeitet
        ->and($res->data['items'][1]['status'])->toBe('error');
});

it('constructor fails when inner handler lacks \\CommandHandler\\ in FQCN', function () {
    $inner = new \Tests\Fixtures\BadInner\NoMarker\BadInnerHandler();

    expect(fn() => new BatchCommandHandler($inner))
        ->toThrow(\InvalidArgumentException::class);
});

it('constructor fails when inferred command class does not exist', function () {
    $inner = new \Tests\Fixtures\BadInner\CommandHandler\MissingCommandHandler();

    expect(fn() => new BatchCommandHandler($inner))
        ->toThrow(\InvalidArgumentException::class);
});
