<?php

declare(strict_types=1);

namespace Tests\Core\Batch;

use Makro\Command\Command\BatchCommand;
use Makro\Command\Contract\CommandInterface;

it('throws for empty batch', function () {
    expect(fn() => new BatchCommand([]))
        ->toThrow(\InvalidArgumentException::class);
});

it('throws when an item does not implement CommandInterface', function () {
    $bad = new \stdClass(); // kein CommandInterface
    expect(fn() => new BatchCommand([$bad]))
        ->toThrow(\InvalidArgumentException::class);
});

it('reindexes commands to 0..n-1', function () {
    $a = new class implements CommandInterface {};
    $b = new class implements CommandInterface {};
    $batch = new BatchCommand([2 => $a, 5 => $b]);

    expect(array_keys($batch->commands))->toBe([0, 1]); // deckt array_values()
});
