<?php

declare(strict_types=1);

namespace Tests\Core\AbstractCommandHandler;

use Makro\Command\Result\CommandHandlerResult;
use Makro\Command\CommandHandler\AbstractCommandHandler;
use Makro\Command\Contract\CommandInterface;

final class DummyCmd implements CommandInterface {}

final class BadSupportedHandler extends AbstractCommandHandler
{
    /** @return class-string<CommandInterface> */
    protected function supportedCommand(): string
    {
        // absichtlich eine nicht-existierende Klasse zurückgeben,
        // damit assertSupportedCommand() den class_exists()-Zweig trifft
        return 'Tests\\Core\\AbstractCommandHandler\\ThisClassDoesNotExist';
    }

    protected function doHandle(CommandInterface $command): CommandHandlerResult
    {
        return CommandHandlerResult::success();
    }
}

it('fails in assertSupportedCommand() when supportedCommand() returns non-existing class', function () {
    $h = new BadSupportedHandler();

    // irgendein Command-Objekt, damit handle() losläuft
    $cmd = new DummyCmd();

    expect(fn() => $h->handle($cmd))
        ->toThrow(\LogicException::class); // trifft den class_exists()-Guard
});
