<?php

declare(strict_types=1);

namespace Tests\Core\AbstractCommandHandler;

use Makro\Command\CommandHandler\AbstractCommandHandler;
use Makro\Command\Result\CommandHandlerResult;
use Makro\Command\Contract\CommandInterface;

// ==== Fixtures (Konventionstreu) ====

// Command unter RootNs
namespace Tests\Fixtures\Demo\Command;
use Makro\Command\Contract\CommandInterface;
final class DemoCommand implements CommandInterface {}

namespace Tests\Fixtures\Demo\Guard;
use Makro\Command\Contract\CommandInterface;
use Makro\Command\Contract\CommandGuardInterface;
use Makro\Command\Contract\CommandHandlerGuardInterface;
use Makro\Command\Contract\CommandHandlerInterface;

final class DemoCommandGuard implements CommandGuardInterface {
    public static int $calls = 0;
    public function assert(CommandInterface $command): void { self::$calls++; }
}
final class DemoCommandHandlerGuard implements CommandHandlerGuardInterface {
    public static int $calls = 0;
    public function assert(CommandHandlerInterface $handler): void { self::$calls++; }
}

// Handler im erwarteten Namespace + Suffix
namespace Tests\Fixtures\Demo\CommandHandler;
use Makro\Command\CommandHandler\AbstractCommandHandler;
use Makro\Command\Result\CommandHandlerResult;
use Makro\Command\Contract\CommandInterface;
use Tests\Fixtures\Demo\Command\DemoCommand;

/** @extends AbstractCommandHandler<DemoCommand> */
final class DemoCommandHandler extends AbstractCommandHandler {
    /** @param DemoCommand $command */
    protected function doHandle(CommandInterface $command): CommandHandlerResult {
        return CommandHandlerResult::success(['ok' => true]);
    }
}

// ==== Tests ====
namespace Tests\Core\AbstractCommandHandler;

use Tests\Fixtures\Demo\CommandHandler\DemoCommandHandler;
use Tests\Fixtures\Demo\Command\DemoCommand;
use Tests\Fixtures\Demo\Guard\DemoCommandGuard;
use Tests\Fixtures\Demo\Guard\DemoCommandHandlerGuard;

it('infers command and runs both default guards once', function () {
    DemoCommandGuard::$calls = 0;
    DemoCommandHandlerGuard::$calls = 0;

    $handler = new DemoCommandHandler();
    $res = $handler->handle(new DemoCommand());

    expect($res->success)->toBeTrue()
        ->and($res->data['ok'])->toBeTrue()
        ->and(DemoCommandHandlerGuard::$calls)->toBe(1)
        ->and(DemoCommandGuard::$calls)->toBe(1);
});
