<?php

declare(strict_types=1);

/**
 * Dieser Test prüft die Namenskonvention:
 *   Makro\X\CommandHandler\FooCommandHandler
 * => Makro\X\FooCommand
 * => Makro\X\Guard\FooCommandGuard
 * => Makro\X\Guard\FooCommandHandlerGuard
 *
 * Beide Guards sollen (je) genau einmal aufgerufen werden.
 */

namespace Tests\Core\AbstractCommandHandler;

use Makro\Command\Result\CommandHandlerResult;
use Makro\Command\Contract\CommandInterface;

/* ===================== Fixtures (konventionskonform) ===================== */
namespace Tests\Fixtures\Convention\Command;

use Makro\Command\Contract\CommandInterface as CI;

final class ConvCommand implements CI {}

namespace Tests\Fixtures\Convention\Guard;

use Makro\Command\Contract\CommandInterface;
use Makro\Command\Contract\CommandGuardInterface;
use Makro\Command\Contract\CommandHandlerGuardInterface;
use Makro\Command\Contract\CommandHandlerInterface;

final class ConvCommandGuard implements CommandGuardInterface
{
    public static int $calls = 0;

    public function assert(CommandInterface $command): void
    {
        self::$calls++;
    }
}

final class ConvCommandHandlerGuard implements CommandHandlerGuardInterface
{
    public static int $calls = 0;

    public function assert(CommandHandlerInterface $handler): void
    {
        self::$calls++;
    }
}

namespace Tests\Fixtures\Convention\CommandHandler;

use Makro\Command\CommandHandler\AbstractCommandHandler;
use Makro\Command\Result\CommandHandlerResult;
use Makro\Command\Contract\CommandInterface;
use Tests\Fixtures\Convention\Command\ConvCommand;

/** @extends AbstractCommandHandler<ConvCommand> */
final class ConvCommandHandler extends AbstractCommandHandler
{
    /** @param ConvCommand $command */
    protected function doHandle(CommandInterface $command): CommandHandlerResult
    {
        return CommandHandlerResult::success(['ok' => true]);
    }
}

/* ============================== Tests =================================== */
namespace Tests\Core\AbstractCommandHandler;

use Tests\Fixtures\Convention\CommandHandler\ConvCommandHandler;
use Tests\Fixtures\Convention\Command\ConvCommand;
use Tests\Fixtures\Convention\Guard\ConvCommandGuard;
use Tests\Fixtures\Convention\Guard\ConvCommandHandlerGuard;

it('infers command and default guards via naming convention', function () {
    // reset counters
    ConvCommandGuard::$calls = 0;
    ConvCommandHandlerGuard::$calls = 0;

    $handler = new ConvCommandHandler();
    $result = $handler->handle(new ConvCommand());

    expect($result->success)->toBeTrue()
        ->and($result->data['ok'])->toBeTrue()
        ->and(ConvCommandHandlerGuard::$calls)->toBe(1)
        ->and(ConvCommandGuard::$calls)->toBe(1);
});
