<?php

declare(strict_types=1);

/**
 * Globaler Namespace: Stubs für Yii/LimeSurvey Klassen
 */
namespace {

    if (!class_exists('Yii', false)) {

        class Yii
        {
            public static function app()
            {
                return new class {
                    public $user;

                    public function __construct()
                    {
                        $this->user = (object)['id' => 1];
                    }

                    public function loadHelper($name)
                    {/* no-op */
                    }
                };
            }
        }

        class Permission
        {
            public static function model()
            {
                return new self;
            }

            public function copySurveyPermissions($from, $to)
            { /* no-op */
            }

            public function hasGlobalPermission($context, $action, $userId = null)
            {
                return true;
            }
        }

        class User
        {
            public static function model()
            {
                return new self;
            }

            public function findByPk($id)
            {
                return (object)['uid' => $id];
            }
        }

        class Survey
        {
            public $startdate;
            public $expires;
            public $owner_id;
            public $admin;
            public $adminemail;

            public static function model()
            {
                return new self;
            }

            public function findByPk($id)
            {
                if ($id < 1000) {
                    return (object)['sid' => $id, 'defaultlanguage' => 'en'];
                }
                return new self;
            }

            public function save($validate, array $fields)
            {
                return true;
            }
        }

        class Token
        {
            public static function createTable($sid)
            {
                return true;
            }
        }

        class SurveyActivator
        {
            public function __construct($survey)
            {
            }

            public function activate()
            { /* no-op */
            }
        }
    }
}

/**
 * Handler-Namespace: Funktionsstubs + State
 * (dein Handler ruft unqualifizierte Funktionen in DIESEM Namespace auf)
 */
namespace Makro\CopySurvey\CommandHandler {
    final class StubState {
        public static bool $xmlOk = true;
        public static bool $importOk = true;
        public static bool $tableExists = true;
        public static bool $tokenCreateOk = true;
        public static bool $activateOk = true;
        public static int  $newsid = 1337;
    }

    function surveyGetXMLData($sid) {
        return StubState::$xmlOk ? '<xml/>' : '';
    }

    function XMLImportSurvey($ctx, $xml, $title) {
        if (!StubState::$importOk) {
            return ['errors' => ['simulated import error']];
        }
        return ['newsid' => StubState::$newsid];
    }

    function tableExists($name) {
        return StubState::$tableExists;
    }
}
