<?php

declare(strict_types=1);

namespace Makro\Command\Result;

final class CommandHandlerResult
{
    public function __construct(
        public bool    $success,
        public ?string $message = null,
        /** @var array<string,mixed> */
        public array   $data = []
    ) {
    }

    /** @param array<string,mixed> $data */
    public static function success(array $data = [], ?string $message = null): self
    {
        return new self(true, $message, $data);
    }

    /** @param array<string,mixed> $data */
    public static function failure(string $message, array $data = []): self
    {
        return new self(false, $message, $data);
    }
}
