<?php

declare(strict_types=1);

namespace Makro\Command\Command;

use InvalidArgumentException;
use Makro\Command\Contract\CommandInterface;

/**
 * @template T of CommandInterface
 */
final class BatchCommand implements CommandInterface
{
    /** @var list<T> */
    public array $commands;

    /**
     * non-empty-array<int, mixed> $commands  raw input; validated & normalized to list<T>
     */
    public function __construct(array $commands, public bool $stopOnFirstError = false)
    {
        if ($commands === []) {
            throw new InvalidArgumentException('Batch commands must not be empty.');
        }

        $this->commands = array_values($commands);

        $normalized = [];
        foreach ($commands as $i => $cmd) {
            if (!$cmd instanceof CommandInterface) {
                $got = is_object($cmd) ? $cmd::class : gettype($cmd);
                throw new InvalidArgumentException("commands[$i] must implement CommandInterface, {$got} given");
            }

            /** @var T $cmd */
            $normalized[] = $cmd; // ergibt automatisch eine 0..n-1 Liste
        }

        /** @var list<T> $normalized */
        $this->commands = $normalized;
    }
}
