<?php

declare(strict_types=1);

namespace Makro\Tagger\Presentation\Http\RequestHandler;

use Laminas\Diactoros\Response\HtmlResponse;
use Laminas\Diactoros\Response\RedirectResponse;
use Makro\Tagger\Domain\Context;
use Makro\Tagger\Presentation\Form\LoginForm;
use Makro\Tagger\Presentation\Routing\UrlGenerator;
use Makro\Tagger\Presentation\View\TemplateRenderer;
use Psr\Http\Message\ServerRequestInterface;
use Psr\Http\Message\ResponseInterface;
use Psr\Http\Server\RequestHandlerInterface;
use Yii;

final class LoginRequestHandler implements RequestHandlerInterface
{
    public function __construct(
        private TemplateRenderer $renderer,
        private UrlGenerator $urlGenerator,
    )
    {
    }

    public function handle(ServerRequestInterface $request): ResponseInterface
    {
        /** @var Context $context */
        $context = $request->getAttribute('context');

        $model = new LoginForm($context);

        if (Yii::app()->request->isPostRequest) {
            $model->attributes = $_POST[str_replace('\\', '_', LoginForm::class)];
            if ($model->validate() && $model->login()) {
                $url = $this->urlGenerator->route('coder-home', ['sid' => $request->getAttribute('sid')]);
                return new RedirectResponse($url);
            }
        }

        $html = $this->renderer->render('login', [
            'model' => $model,
        ]);

        return new HtmlResponse($html);
    }
}
