<?php

declare(strict_types=1);

namespace Makro\Tagger\Presentation\Http\RequestHandler;

use Laminas\Diactoros\Response\RedirectResponse;
use Makro\Tagger\Presentation\Routing\UrlGenerator;
use Psr\Http\Message\ServerRequestInterface;
use Psr\Http\Message\ResponseInterface;
use Psr\Http\Server\RequestHandlerInterface;
use Yii;

final class IndexRequestHandler implements RequestHandlerInterface
{
    public function __construct(
        private UrlGenerator $urlGenerator,
    )
    {
    }

    public function handle(ServerRequestInterface $request): ResponseInterface
    {
        if (Yii::app()->user->id) {
            return new RedirectResponse($this->urlGenerator->route('admin-dashboard', ['sid' => $request->getAttribute('sid')]));
        } else {
            return new RedirectResponse($this->urlGenerator->route('coder-home', ['sid' => $request->getAttribute('sid')]));
        }
    }
}
