<?php

declare(strict_types=1);

namespace Makro\Tagger\Presentation\Http\RequestHandler\Coder;

use Laminas\Diactoros\Response\HtmlResponse;
use Makro\Tagger\Application\UseCase\GetCoderHomeData;
use Makro\Tagger\Domain\Context;
use Makro\Tagger\Domain\ValueObject\Coder;
use Makro\Tagger\Presentation\View\TemplateRenderer;
use Psr\Http\Message\ServerRequestInterface;
use Psr\Http\Message\ResponseInterface;
use Psr\Http\Server\RequestHandlerInterface;

final class HomeRequestHandler implements RequestHandlerInterface
{
    public function __construct(
        private TemplateRenderer $renderer
    )
    {
    }

    public function handle(ServerRequestInterface $request): ResponseInterface
    {
        /** @var Context $context */
        $context = $request->getAttribute('context');
        /** @var Coder $coder */
        $coder = $request->getAttribute('coder');

        $data = (new GetCoderHomeData($context, $coder))();
        $html = $this->renderer->render('coder/home', $data);

        return new HtmlResponse($html);
    }
}
