<?php

declare(strict_types=1);

namespace Makro\Tagger\Presentation\Http\RequestHandler\Admin;

use Laminas\Diactoros\Response\HtmlResponse;
use Makro\Tagger\Application\UseCase\GetAdminDashboardData;
use Makro\Tagger\Domain\Context;
use Makro\Tagger\Presentation\Routing\UrlGenerator;
use Makro\Tagger\Presentation\View\TemplateRenderer;
use Psr\Http\Message\ServerRequestInterface;
use Psr\Http\Message\ResponseInterface;
use Psr\Http\Server\RequestHandlerInterface;

final class DashboardRequestHandler implements RequestHandlerInterface
{
    public function __construct(
        private TemplateRenderer $renderer,
        private UrlGenerator $urlGenerator
    )
    {
    }

    public function handle(ServerRequestInterface $request): ResponseInterface
    {
        /** @var Context $context */
        $context = $request->getAttribute('context');
        $data = (new GetAdminDashboardData($context))();

        $assignCodersUrl = $this->urlGenerator->route('assign-coders', ['sid' => $context->surveyId()]);
        $html = $this->renderer->render('admin/dashboard', ['assignCodersUrl' => $assignCodersUrl] + $data);

        return new HtmlResponse($html);
    }
}
