<?php

declare(strict_types=1);

namespace Makro\Tagger\Presentation\Http\RequestHandler\Admin;

use Laminas\Diactoros\Response\RedirectResponse;
use Makro\Tagger\Application\UseCase\AssignCoders\Command\AssignCodersCommand;
use Makro\Tagger\Application\UseCase\AssignCoders\CommandHandler\AssignCodersCommandHandler;
use Makro\Tagger\Domain\Context;
use Makro\Tagger\Presentation\Routing\UrlGenerator;
use Psr\Http\Message\ServerRequestInterface;
use Psr\Http\Message\ResponseInterface;
use Psr\Http\Server\RequestHandlerInterface;
use Yii;

final class AssignCodersRequestHandler implements RequestHandlerInterface
{
    public function __construct(
        private AssignCodersCommandHandler $commandHandler,
        private UrlGenerator $urlGenerator,
    )
    {
    }

    public function handle(ServerRequestInterface $request): ResponseInterface
    {
        if (Yii::app()->request->isPostRequest) {

            try {

                /** @var Context $context */
                $context = $request->getAttribute('context');

                $command = new AssignCodersCommand($context);
                $this->commandHandler->handle($command);

                Yii::app()->user->setFlash('success', 'Coders successfully assigned.');

            } catch (\Throwable $e) {
                Yii::app()->user->setFlash('error', 'Error while assigning coders: ' . $e->getMessage());
            }

        }

        $url = $this->urlGenerator->route('admin-dashboard', ['sid' => $request->getAttribute('sid')]);
        return new RedirectResponse($url);

    }
}
