<?php

declare(strict_types=1);

namespace Makro\Tagger\Presentation\Http;

use Laminas\Diactoros\ResponseFactory;
use Laminas\Diactoros\ServerRequestFactory;
use Laminas\Diactoros\StreamFactory;
use Laminas\HttpHandlerRunner\Emitter\SapiEmitter;
use Laminas\HttpHandlerRunner\RequestHandlerRunner;
use Laminas\Stratigility\MiddlewarePipe;
use Makro\Tagger\Presentation\Http\Middleware\ContextMiddleware;
use Makro\Tagger\Presentation\Http\Middleware\QidGuardMiddleware;
use Makro\Tagger\Presentation\Http\Middleware\SidGuardMiddleware;
use Psr\Container\ContainerInterface;
use Makro\Tagger\Presentation\Http\Middleware\AuthSelectorMiddleware;
use Makro\Tagger\Presentation\Http\Middleware\ActionDispatcherMiddleware;

final class NewDirectRequest
{
    public function __construct(
        private ContainerInterface $container,
        private array              $handlerMap,
        private array              $authMap
    )
    {
    }

    public function run(): void
    {
        $app = new MiddlewarePipe();

        $app->pipe($this->container->get(SidGuardMiddleware::class));
        $app->pipe($this->container->get(ContextMiddleware::class));
        $app->pipe($this->container->get(QidGuardMiddleware::class));

        $app->pipe(new AuthSelectorMiddleware($this->container, [
            'handlerMap' => $this->handlerMap,
            'authMap' => $this->authMap,
        ]));

        $app->pipe(new ActionDispatcherMiddleware(
            $this->container,
            $this->handlerMap
        ));

        $server = new RequestHandlerRunner(
            $app,
            new SapiEmitter(),
            static fn() => ServerRequestFactory::fromGlobals(),
            static fn(\Throwable $e) => (new ResponseFactory())
                ->createResponse(500)
                ->withBody(
                    (new StreamFactory())->createStream(
                        'Internal Server Error: ' . $e->getMessage()
                    )
                )
        );

        $server->run();
    }
}
