<?php

declare(strict_types=1);

namespace Makro\Tagger\Presentation\Http\Middleware;

use Laminas\Diactoros\Response\HtmlResponse;
use Makro\Tagger\Presentation\View\TemplateRenderer;
use Psr\Http\Message\ResponseInterface;
use Psr\Http\Message\ServerRequestInterface;
use Psr\Http\Server\MiddlewareInterface;
use Psr\Http\Server\RequestHandlerInterface;
use Survey;
use Tagger;

final class SidGuardMiddleware implements MiddlewareInterface
{
    public function __construct(
        private TemplateRenderer $renderer,
        private Tagger $plugin
    )
    {
    }

    public function process(ServerRequestInterface $request, RequestHandlerInterface $handler): ResponseInterface
    {
        $sid = $request->getQueryParams()['sid'] ?? null;

        if (empty($sid)) {
            $this->error('Error', 'Missing required query parameter: sid');
        }

        $survey = Survey::model()->findByPk($sid);
        if (!$survey) {
            $this->error('Error', 'Survey not found');
        }

        if (!$this->plugin->getIsActive($sid)) {
            $this->error('Error', 'Plugin is not active for this survey');
        }

        $request = $request->withAttribute('sid', $sid);

        return $handler->handle($request);
    }

    private function error(string $title, string $message)
    {
        $html = $this->renderer->render('error', [
            'title' => $title,
            'message' => $message,
        ]);

        return new HtmlResponse($html);
    }
}
