<?php

declare(strict_types=1);

namespace Makro\Tagger\Presentation\Http\Middleware;

use Laminas\Diactoros\Response\RedirectResponse;
use Makro\Tagger\Domain\Context;
use Makro\Tagger\Domain\ValueObject\CodingQuestion;
use Makro\Tagger\Presentation\Routing\UrlGenerator;
use Psr\Http\Message\ResponseInterface;
use Psr\Http\Message\ServerRequestInterface;
use Psr\Http\Server\MiddlewareInterface;
use Psr\Http\Server\RequestHandlerInterface;
use Yii;

final class QidGuardMiddleware implements MiddlewareInterface
{
    public function __construct(
        private UrlGenerator $urlGenerator,
    )
    {

    }

    public function process(ServerRequestInterface $request, RequestHandlerInterface $handler): ResponseInterface
    {
        $sid = (int)$request->getAttribute('sid');
        $qid = $request->getQueryParams()['qid'] ?? null;
        $qid = $qid !== null ? (int)$qid : null;

        if (empty($qid)) {
            return $handler->handle($request);
        }

        /** @var Context $context */
        $context = $request->getAttribute('context');

        $question = $context
            ->codingQuestionCollection()
            ->firstWhere(fn(CodingQuestion $q) => $q->sid() === $sid && $q->qid() === $qid);

        if (!$question) {
            Yii::app()->coder->setFlash('error', 'Invalid or unknown question ID.');
            $url = $this->urlGenerator->route('coder-home', ['sid' => $sid]);
            return new RedirectResponse($url);
        }

        $request = $request->withAttribute('question', $question);

        return $handler->handle($request);
    }
}
