<?php

declare(strict_types=1);

namespace Makro\Tagger\Presentation\Http\Middleware;

use Makro\Tagger\Application\Context\Factory;
use Makro\Tagger\Domain\Context;
use Psr\Http\Message\ResponseInterface;
use Psr\Http\Message\ServerRequestInterface;
use Psr\Http\Server\MiddlewareInterface;
use Psr\Http\Server\RequestHandlerInterface;
use Tagger;

final class ContextMiddleware implements MiddlewareInterface
{
    public function __construct(
        private Factory $factory,
        private Tagger $plugin
    )
    {
    }

    public function process(ServerRequestInterface $request, RequestHandlerInterface $handler): ResponseInterface
    {
        $surveyId = intval($request->getAttribute('sid'));
        $shareForCoder2 = $this->plugin->getShareForCoder2($surveyId);
        $coders = $this->plugin->getCoders($surveyId);
        $language = 'en';

        $context = $this->factory->make(
            surveyId: $surveyId,
            coders: $coders,
            shareForCoder2: $shareForCoder2,
            language: $language
        );

        return $handler->handle($request->withAttribute('context', $context));
    }
}
