<?php

declare(strict_types=1);

namespace Makro\Tagger\Presentation\Http\Middleware;

use Laminas\Diactoros\Response\RedirectResponse;
use Makro\Tagger\Domain\ValueObject\Coder;
use Makro\Tagger\Presentation\Routing\UrlGenerator;
use Psr\Http\Message\ResponseInterface;
use Psr\Http\Message\ServerRequestInterface;
use Psr\Http\Server\MiddlewareInterface;
use Psr\Http\Server\RequestHandlerInterface;
use Yii;

final class CoderAuthMiddleware implements MiddlewareInterface
{

    public function __construct(
        private UrlGenerator $urlGenerator,
    )
    {
    }

    public function process(ServerRequestInterface $request, RequestHandlerInterface $handler): ResponseInterface
    {
        if (Yii::app()->coder->isGuest) {
            $url = $this->urlGenerator->route('login', ['sid' => $request->getAttribute('sid')]);
            return new RedirectResponse($url);
        }

        $coder = new Coder(Yii::app()->coder->getId(), '');

        return $handler->handle($request->withAttribute('coder', $coder));
    }
}
