<?php

declare(strict_types = 1);

namespace Makro\Tagger\Presentation\Http\Middleware;

use Laminas\Diactoros\Response\HtmlResponse;
use Makro\Tagger\Presentation\View\TemplateRenderer;
use Psr\Http\Server\MiddlewareInterface;
use Psr\Http\Message\ServerRequestInterface;
use Psr\Http\Message\ResponseInterface;
use Psr\Http\Server\RequestHandlerInterface;
use Yii;

final class AdminAuthMiddleware implements MiddlewareInterface
{
    public function __construct(
        private TemplateRenderer $renderer,
    )
    {
    }

    public function process(ServerRequestInterface $request, RequestHandlerInterface $handler): ResponseInterface
    {
        $user = Yii::app()->user;

        if ($user->isGuest) {
            $html = $this->renderer->render('error', [
                'title' => 'Error',
                'message' => 'You are not allowed to access this page.',
            ]);

            return new HtmlResponse($html);
        }

        return $handler->handle($request);
    }
}
