<?php

declare(strict_types=1);

namespace Makro\Tagger\Presentation\Http\Middleware;

use Laminas\Diactoros\Response\HtmlResponse;
use Psr\Container\ContainerInterface;
use Psr\Http\Message\ResponseInterface;
use Psr\Http\Message\ServerRequestInterface;
use Psr\Http\Server\MiddlewareInterface;
use Psr\Http\Server\RequestHandlerInterface;
use Psr\Http\Server\RequestHandlerInterface as Handler;

final class ActionDispatcherMiddleware implements MiddlewareInterface
{
    public function __construct(
        private ContainerInterface $container,
        private array              $handlerMap
    )
    {
    }

    public function process(ServerRequestInterface $request, RequestHandlerInterface $handler): ResponseInterface
    {
        $params = $request->getQueryParams();
        $action = $params['action'] ?? 'index';

        if (!isset($this->handlerMap[$action])) {
            return new HtmlResponse(
                sprintf('<h1>404 Not Found</h1><p>No handler for action "%s"</p>', htmlspecialchars($action)),
                404
            );
        }

        $handlerClass = $this->handlerMap[$action];
        $handler = $this->container->get($handlerClass);

        if (!$handler instanceof Handler) {
            throw new \RuntimeException(sprintf(
                'Handler %s must implement %s',
                $handlerClass,
                Handler::class
            ));
        }

        return $handler->handle($request);
    }
}
