<?php

namespace Makro\Tagger\Presentation\Form;

use CBaseUserIdentity;
use Makro\Tagger\Domain\Context;
use Makro\Tagger\Infrastructure\Auth\CoderIdentity;
use Yii;

class LoginForm extends \CFormModel
{
    public $id;
    public $password;

    private Context $context;
    private ?CoderIdentity $identity = null;

    public function __construct(Context $context)
    {
        parent::__construct();
        $this->context = $context;
    }

    public function rules(): array
    {
        return [
            ['id, password', 'required'],
        ];
    }

    public function attributeLabels(): array
    {
        return [
            'id' => 'Coder Id',
            'password' => 'Password',
        ];
    }

    public function authenticate()
    {
        if (!$this->hasErrors()) {
            $this->identity = new CoderIdentity($this->context, $this->id, $this->password);
            if (!$this->identity->authenticate()) {
                $this->addError('password', 'Invalid username or password.');
            }
        }
    }

    public function login()
    {
        $this->authenticate();

        if ($this->identity === null || $this->identity->errorCode !== CBaseUserIdentity::ERROR_NONE) {
            return false;
        }

        return Yii::app()->coder->login($this->identity);
    }
}
