<?php

declare(strict_types = 1);

namespace Makro\Tagger\Infrastructure\View;

use League\Plates\Engine;
use Makro\Tagger\Presentation\View\TemplateRenderer;

final class PlatesTemplateRenderer implements TemplateRenderer
{
    public function __construct(private Engine $engine)
    {
    }

    public function render(string $template, array $data = []): string
    {
        return $this->engine->render($template, $data);
    }
}
