<?php

declare(strict_types=1);

namespace Makro\Tagger\Infrastructure\Routing;

use Makro\Tagger\Presentation\Routing\UrlGenerator;
use Yii;

class PluginUrlGenerator implements UrlGenerator
{

    public function __construct(
        private string $pluginName
    )
    {

    }
    public function route(string $action, array $params = []): string
    {
        $params = array_merge([
            'plugin' => $this->pluginName,
            'action' => $action
        ], $params);

        return Yii::app()->createAbsoluteUrl('plugins/direct', $params);
    }
}
