<?php

declare(strict_types = 1);

namespace Makro\Tagger\Infrastructure\Provider\InMemory;

use Makro\Tagger\Domain\Context;
use Makro\Tagger\Domain\ValueObject\CodingQuestion;
use Makro\Tagger\Domain\Collection\CodingQuestionCollection;
use Makro\Tagger\Domain\Provider\CodingQuestionCollectionProvider;

final class InMemoryCodingQuestionsProvider implements CodingQuestionCollectionProvider
{
    /** @var array<int, array<string, CodingQuestion[]>> sid => [lang => [CQ...]] */
    private array $map = [];

    public function seed(int $surveyId, string $language, CodingQuestion ...$questions): void
    {
        $this->map[$surveyId][$language] = $questions;
    }

    public function provide(Context $context): CodingQuestionCollection
    {
        $surveyId = $context->surveyId();
        $language = $context->language();

        $items = $this->map[$surveyId][$language] ?? [];
        return new CodingQuestionCollection($surveyId, $items, $language);
    }
}
