<?php

declare(strict_types = 1);

namespace Makro\Tagger\Infrastructure\Provider\Db;

use Makro\Tagger\Domain\Context;
use Makro\Tagger\Domain\ValueObject\CodingQuestion;
use Makro\Tagger\Domain\Collection\CodingQuestionCollection;
use Makro\Tagger\Domain\Provider\CodingQuestionCollectionProvider;
use Yii;

final class DbCodingQuestionCollectionProvider implements CodingQuestionCollectionProvider
{
    const QUESTION_ATTRIBUTE = 'taggable';

    public function provide(Context $context): CodingQuestionCollection
    {
        $sid = $context->surveyId();
        $language = $context->language();

        $items = [];

        /** @noinspection SqlNoDataSourceInspection */
        $sql = <<<SQL
                SELECT q.qid, q.sid, q.title, ql.question
                  FROM {{questions}} AS q
                  JOIN {{question_l10ns}} AS ql ON ql.qid = q.qid
                  JOIN {{question_attributes}} AS qa ON qa.qid = q.qid
                 WHERE qa.attribute = :attribute AND qa.value = 1
                   AND ql.language = :language 
                   AND q.sid = :sid
              ORDER BY q.question_order
        SQL;

        $rows = Yii::app()->db->createCommand($sql)->queryAll(true, [
            ':sid' => $sid,
            ':attribute' => self::QUESTION_ATTRIBUTE,
            ':language' => $language,
        ]);

        foreach ($rows as $row) {
            $items[] = new CodingQuestion(
                sid: $sid,
                qid: (int)$row['qid'],
                title: $row['title'],
                text: $row['question'],
            );
        }

        return new CodingQuestionCollection($sid, $items, $language);
    }
}
