<?php

declare(strict_types = 1);

namespace Makro\Tagger\Infrastructure\Provider\Db;

use Makro\Tagger\Domain\Collection\CodingCollection;
use Makro\Tagger\Domain\Context;
use Makro\Tagger\Domain\Provider\CodingCollectionProvider;
use Makro\Tagger\Domain\Repository\CodingRepository;

class DbCodingCollectionProvider implements CodingCollectionProvider
{
    public function __construct(
        private CodingRepository $codingRepository,
    )
    {
    }

    public function provide(Context $context): CodingCollection
    {
        return $this->codingRepository->findAll($context);
    }
}
