<?php

declare(strict_types = 1);

namespace Makro\Tagger\Infrastructure\Provider\Db;

use Answer;
use Makro\Tagger\Domain\Context;
use Makro\Tagger\Domain\Provider\AnswerProvider;
use Makro\Tagger\Domain\Entity\Coding;
use Question;

class DbAnswerProvider implements AnswerProvider
{
    private ?array $cachedAnswers = null;

    public function __construct(
        private Context $context
    )
    {
    }

    public function provide(Coding $coding): array
    {
        $sid = $coding->codingQuestion()->sid();

        if ($this->cachedAnswers === null) {

            $tagQuestion = Question::model()->findByAttributes([
                'sid' => $sid,
                'title' => $coding->c1TagTitle()
            ]);

            $this->cachedAnswers['tag'] = $this->getAnswers($tagQuestion, $this->context->language());

            $pIIQuestion = Question::model()->findByAttributes([
                'sid' => $sid,
                'title' => $coding->c1PIITitle()
            ]);

            $this->cachedAnswers['pII'] = $this->getAnswers($pIIQuestion, $this->context->language());
        }

        return $this->cachedAnswers;
    }

    private function getAnswers(Question $question, string $language): array
    {
        $answers = Answer::model()
            ->with([
                'answerl10ns' => [
                    'condition' => 'language = :language',
                    'params' => [
                        ':language' => $language
                    ]
                ]
            ])
            ->findAllByAttributes([
                'qid' => $question->getPrimaryKey()
            ]);

        return array_reduce($answers, function ($carry, $item) use ($language) {
            $carry[$item->code] = $item->answerl10ns[$language]->answer;
            return $carry;
        }, []);
    }
}
