<?php

declare(strict_types=1);

namespace Makro\Tagger\Infrastructure\Persistence\Db;

use Makro\Tagger\Domain\Collection\CodingQuestionCollection;
use Makro\Tagger\Domain\Context;
use Makro\Tagger\Domain\Repository\CodingQuestionRepository;
use Makro\Tagger\Domain\ValueObject\CodingQuestion;
use Question;

class DbCodingQuestionRepository implements CodingQuestionRepository
{

    public function findAll(int $surveyId, string $language): CodingQuestionCollection
    {
        return new CodingQuestionCollection($surveyId, [], $language);
    }

    public function findAllByContext(Context $context): CodingQuestionCollection
    {
        return new CodingQuestionCollection($context->surveyId(), [], $context->language());
    }

    public function find(int $surveyId, int $questionId, string $language): ?CodingQuestion
    {
        $question = Question::model()
            ->with([
                'questionl10ns' => [
                    'condition' => 'language = :language',
                    'params'    => [
                        'language' => $language
                    ],
                ]
            ])
            ->findByAttributes([
                'sid' => $surveyId,
                'qid' => $questionId
            ]);

        if ($question) {
            return new CodingQuestion(
                sid: $surveyId,
                qid: $questionId,
                title: $question->title,
                text: $question->questionl10ns[$language]->question
            );
        }

        return null;
    }

    public function findByContext(Context $context, int $questionId): ?CodingQuestion
    {
        return $this->find($context->surveyId(), $questionId, $context->language());
    }
}
