<?php
declare(strict_types=1);

namespace Makro\Tagger\Domain\ValueObject;

final class Status
{
    public const UNASSIGNED = 0; // initial
    public const AWAITS_CODING = 1; // coders assigned
    public const CONFLICTUAL = 3; // both finished, but conflict
    public const DONE = 4; // finished

    public static function isUnassigned(?int $status): bool
    {
        $s = $status ?? self::UNASSIGNED;
        return $s === self::UNASSIGNED;
    }

    public static function isDone(?int $status): bool
    {
        $s = $status ?? self::DONE;
        return $s === self::DONE;
    }

    public static function hasConflicts(?int $status): bool
    {
        $s = $status ?? self::CONFLICTUAL;
        return $s === self::CONFLICTUAL;
    }

    public static function awaitsCoding(?int $status): bool
    {
        $s = $status ?? self::AWAITS_CODING;
        return $s === self::AWAITS_CODING;
    }

    public static function normalize($value): int
    {
        if ($value === null || $value === '') {
            return self::UNASSIGNED;
        }

        return (int)$value;
    }

    public static function label(int $s): string
    {
        return match ($s) {
            self::UNASSIGNED => 'unassigned',
            self::AWAITS_CODING => 'awaitsCoding',
            self::CONFLICTUAL => 'conflictual',
            self::DONE => 'done',
            default => 'unknown',
        };
    }
}
