<?php

declare(strict_types = 1);

namespace Makro\Tagger\Domain\ValueObject;

class CodingQuestion
{
    public function __construct(
        private int $sid,
        private int $qid,
        private string $title,
        private string $text
    ) {
    }

    public function surveyId(): int
    {
        return $this->sid;
    }

    public function sid(): int
    {
        return $this->sid;
    }

    public function questionId(): int
    {
        return $this->qid;
    }

    public function qid(): int
    {
        return $this->qid;
    }

    public function title(): string
    {
        return $this->title;
    }

    public function text(): string
    {
        return $this->text;
    }

    public function equals(self $other): bool
    {
        return $this->sid === $other->sid && $this->qid === $other->qid;
    }
}
