<?php

declare(strict_types=1);

namespace Makro\Tagger\Domain\ValueObject;

class CodingEntry
{
    private ?string $coderId;
    private ?string $tag;
    private ?string $pii;
    private ?string $comment;

    public function __construct(?string $coderId = null, ?string $tag = null, ?string $pii = null, ?string $comment = null)
    {
        $this->coderId = $this->norm($coderId);
        $this->tag = $this->norm($tag);
        $this->pii = $this->norm($pii);
        $this->comment = $comment;
    }

    private function norm(?string $v): ?string
    {
        if ($v === null) return null;
        $t = trim($v);
        return $t === '' ? null : $t;
    }

    public function coderId(): ?string
    {
        return $this->coderId;
    }

    public function tag(): ?string
    {
        return $this->tag;
    }

    public function pii(): ?string
    {
        return $this->pii;
    }

    public function comment(): ?string
    {
        return $this->comment;
    }

    public function isAssigned(): bool
    {
        return $this->coderId !== null;
    }

    public function isSubmitted(): bool
    {
        return $this->tag !== null && $this->pii !== null;
    }

    public function isSubmittedBy(Coder $coder): bool
    {
        return $this->isSubmitted() && $this->coderId === $coder->id();
    }

    public function conflictsWith(self $other): bool
    {
        if (!$this->isSubmitted() || !$other->isSubmitted()) return false;
        return $this->tag !== $other->tag || $this->pii !== $other->pii;
    }

    public function withCoderId(?string $id): self
    {
        $c = clone $this;
        $c->coderId = $this->norm($id);
        return $c;
    }

    public function withSubmission(?string $tag, ?string $pii, ?string $comment = null): self
    {
        $c = clone $this;
        $c->tag = $this->norm($tag);
        $c->pii = $this->norm($pii);
        $c->comment = $comment;
        return $c;
    }
}

