<?php

declare(strict_types=1);

namespace Makro\Tagger\Domain\ValueObject;

final class CodingCollectionStatsPercent
{
    public function __construct(
        private CodingCollectionStats $stats
    )
    {
    }

    private function percent(int $part, int $total, int $precision = 1): float
    {
        if ($total === 0) {
            return 0.0;
        }

        return round(($part / $total) * 100, $precision);
    }

    public function total(): int
    {
        return $this->stats->totalCount();
    }

    public function done(): float
    {
        return $this->percent($this->stats->doneCount(), $this->stats->totalCount());
    }

    public function unassigned(): float
    {
        return $this->percent($this->stats->unassignedCount(), $this->stats->totalCount());
    }

    public function awaiting(): float
    {
        return $this->percent($this->stats->awaitingCount(), $this->stats->totalCount());
    }

    public function haveConflicts(): float
    {
        return $this->percent($this->stats->haveConflictsCount(), $this->stats->totalCount());
    }
}
