<?php

declare(strict_types=1);

namespace Makro\Tagger\Domain\ValueObject;

use Makro\Tagger\Domain\Collection\CodingCollection;

class CodingCollectionStats
{
    public function __construct(
        private CodingCollection $codings,
        private string $name = '',
    )
    {
    }

    public function name(): string
    {
        return $this->name;
    }

    public function totalCount(): int
    {
        return $this->codings->count();
    }

    public function unassignedCount(): int
    {
        return count($this->codings->unassigned());
    }

    public function awaitingCount(): int
    {
        return count($this->codings->awaiting());
    }

    public function haveConflictsCount(): int
    {
        return count($this->codings->haveConflicts());
    }

    public function doneCount(): int
    {
        return count($this->codings->done());
    }
}
