<?php

declare(strict_types = 1);

namespace Makro\Tagger\Domain\ValueObject;

class Coder
{
    public function __construct(
        private string $id,
        private string $password
    ) {}

    public function id(): string
    {
        return $this->id;
    }

    public function password(): string
    {
        return $this->password;
    }

    public function equals(Coder $coder): bool
    {
        return $coder->id() === $this->id;
    }
}
