<?php

declare(strict_types = 1);

namespace Makro\Tagger\Domain\Repository;

use Makro\Tagger\Domain\Collection\CodingCollection;
use Makro\Tagger\Domain\Context;
use Makro\Tagger\Domain\Entity\Coding;
use Makro\Tagger\Domain\ValueObject\CodingQuestion;

interface CodingRepository
{
    public function find(int $responseId, CodingQuestion $question): ?Coding;
    public function findAll(Context $context): CodingCollection;
    public function findAllForQuestion(CodingQuestion $question): CodingCollection;

    public function save(Coding $coding): void;
    public function assignCoders(Coding $coding): bool;
    public function exists(int $responseId, CodingQuestion $question): bool;
}
