<?php

declare(strict_types = 1);

namespace Makro\Tagger\Domain\Repository;

use Makro\Tagger\Domain\Collection\CodingQuestionCollection;
use Makro\Tagger\Domain\Context;
use Makro\Tagger\Domain\ValueObject\CodingQuestion;

interface CodingQuestionRepository
{
    public function findAll(int $surveyId, string $language): CodingQuestionCollection;
    public function findAllByContext(Context $context): CodingQuestionCollection;
    public function find(int $surveyId, int $questionId, string $language): ?CodingQuestion;
    public function findByContext(Context $context, int $questionId): ?CodingQuestion;
}
