<?php

declare(strict_types=1);

namespace Makro\Tagger\Domain\Event;

use Makro\Tagger\Domain\ValueObject\CodingEntry;

final class ConflictResolvedEvent
{
    private int $codingId;
    private CodingEntry $resolution;
    private int $surveyId;
    private int $questionId;

    public function __construct(
        int $codingId,
        CodingEntry $resolution,
        int $surveyId,
        int $questionId
    ) {
        $this->codingId = $codingId;
        $this->resolution = $resolution;
        $this->surveyId = $surveyId;
        $this->questionId = $questionId;
    }

    public function codingId(): int
    {
        return $this->codingId;
    }

    public function resolution(): CodingEntry
    {
        return $this->resolution;
    }

    public function surveyId(): int
    {
        return $this->surveyId;
    }

    public function questionId(): int
    {
        return $this->questionId;
    }

    public function resolverId(): ?string
    {
        return $this->resolution->coderId();
    }

    public function finalTag(): ?string
    {
        return $this->resolution->tag();
    }

    public function finalPii(): ?string
    {
        return $this->resolution->pii();
    }

    public function finalComment(): ?string
    {
        return $this->resolution->comment();
    }
}
