<?php

declare(strict_types=1);

namespace Makro\Tagger\Domain\Event;

use Makro\Tagger\Domain\ValueObject\CodingEntry;

final class C1SubmittedEvent
{
    private int $codingId;
    private CodingEntry $entry;
    private int $surveyId;
    private int $questionId;

    public function __construct(
        int $codingId,
        CodingEntry $entry,
        int $surveyId,
        int $questionId
    ) {
        $this->codingId = $codingId;
        $this->entry = $entry;
        $this->surveyId = $surveyId;
        $this->questionId = $questionId;
    }

    public function codingId(): int
    {
        return $this->codingId;
    }

    public function entry(): CodingEntry
    {
        return $this->entry;
    }

    public function surveyId(): int
    {
        return $this->surveyId;
    }

    public function questionId(): int
    {
        return $this->questionId;
    }

    public function coderId(): ?string
    {
        return $this->entry->coderId();
    }

    public function tag(): ?string
    {
        return $this->entry->tag();
    }

    public function pii(): ?string
    {
        return $this->entry->pii();
    }

    public function comment(): ?string
    {
        return $this->entry->comment();
    }
}
