<?php

declare(strict_types=1);

namespace Makro\Tagger\Domain;

use Makro\Tagger\Domain\Collection\CoderCollection;
use Makro\Tagger\Domain\Collection\CodingCollection;
use Makro\Tagger\Domain\Collection\CodingQuestionCollection;
use Makro\Tagger\Domain\Provider\CoderCollectionProvider;
use Makro\Tagger\Domain\Provider\CodingCollectionProvider;
use Makro\Tagger\Domain\Provider\CodingQuestionCollectionProvider;

class Context
{
    private ?CoderCollection $cachedCoderCollection = null;
    private ?CodingQuestionCollection $cachedCodingQuestionCollection = null;
    private ?CodingCollection $cachedCodingCollection = null;

    public function __construct(
        private int    $surveyId,
        private string $coders,
        private int    $shareForCoder2,
        private string $language,
        private CoderCollectionProvider $coderCollectionProvider,
        private CodingQuestionCollectionProvider $codingQuestionCollectionProvider,
        private CodingCollectionProvider $codingCollectionProvider,
    )
    {
    }

    public function surveyId(): int
    {
        return $this->surveyId;
    }

    public function sid(): int
    {
        return $this->surveyId;
    }

    public function coders(): string
    {
        return $this->coders;
    }

    public function shareForCoder2(): int
    {
        return max(0, min(100, $this->shareForCoder2));
    }

    public function language(): string
    {
        return $this->language;
    }

    public function coderCollection(): CoderCollection
    {
        return $this->cachedCoderCollection
            ??= $this->cachedCoderCollection = $this->coderCollectionProvider->provide($this);
    }

    public function codingQuestionCollection(): CodingQuestionCollection
    {
        return $this->cachedCodingQuestionCollection
            ??= $this->cachedCodingQuestionCollection = $this->codingQuestionCollectionProvider->provide($this);
    }

    public function codingCollection(): CodingCollection
    {
        return $this->cachedCodingCollection
            ??= $this->cachedCodingCollection = $this->codingCollectionProvider->provide($this);
    }
}
