<?php

declare(strict_types=1);

namespace Makro\Tagger\Domain\Collection;

use ArrayIterator;
use Countable;
use InvalidArgumentException;
use IteratorAggregate;
use Makro\Tagger\Domain\ValueObject\Coder;
use Traversable;

class CoderCollection implements IteratorAggregate, Countable
{
    /** @var Coder[] */
    private array $coders = [];

    public function __construct(array $coders = [])
    {
        foreach ($coders as $coder) {
            if (!($coder instanceof Coder)) {
                throw new InvalidArgumentException("Array darf nur Coder-Objekte enthalten");
            }

            $this->coders[] = $coder;
        }
    }

    public function getIterator(): Traversable
    {
        return new ArrayIterator($this->coders);
    }

    public function count(): int
    {
        return count($this->coders);
    }
}
