<?php

declare(strict_types=1);

namespace Makro\Tagger\Application\UseCase\SaveCoding\Command;

use Makro\Command\Contract\CommandInterface;

class SaveCodingCommand implements CommandInterface
{
    public function __construct(
        private int $surveyId,
        private int $responseId,
        private string $language,
        private int $questionId,
        private string $coderId,
        private string $tag,
        private string $pii,
        private string $comment
    )
    {
    }

    public function surveyId(): int
    {
        return $this->surveyId;
    }

   public function responseId(): int
    {
        return $this->responseId;
    }

    public function questionId(): int
    {
        return $this->questionId;
    }

    public function language(): string
    {
        return $this->language;
    }

    public function coderId(): string
    {
        return $this->coderId;
    }

    public function tag(): string
    {
        return $this->tag;
    }

    public function pii(): string
    {
        return $this->pii;
    }

    public function comment(): string
    {
        return $this->comment;
    }

}
