<?php

declare(strict_types=1);

namespace Makro\Tagger\Application\UseCase;

use Makro\Tagger\Domain\Context;
use Makro\Tagger\Domain\ValueObject\Coder;

class GetCoderHomeData
{
    public function __construct(
        private Context $context,
        private Coder $coder
    )
    {
    }

    public function __invoke(): array
    {
        $allCodings = $this->context->codingCollection()->forCoder($this->coder);
        $total = $allCodings->count();

        $submittedCodings = $allCodings->submittedBy($this->coder);
        $done = $submittedCodings->count();

        $data = [];

        $data['_summary'] = [
            'total' => $total,
            'done' => $total > 0 ? round($done / $total * 100) : 0,
        ];

        $data['questions'] = [];
        foreach ($this->context->codingQuestionCollection() as $q) {
            $codings = $allCodings->forQuestion($q);

            $total = $codings->count();
            $submittedCodings = $codings->submittedBy($this->coder);
            $done = $submittedCodings->count();


            $data['questions'][$q->text()] = [
                'sid' => $q->surveyId(),
                'qid' => $q->questionId(),
                'total' => $total,
                'done' => $total > 0 ? round($done / $total * 100) : 0,
            ];
        }

        return $data;
    }
}
